#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.PowerCli as PowerCli
from CliPlugin.ThermoMgrGlobalConfigMode import ( matcherEnvironment,
                                                  matcherInterval,
                                                  matcherPollInterval,
                                                  matcherMilliseconds,
                                                  matcherSeconds )
from CliMatcher import IntegerMatcher

#--------------------------------------------------------------------------------
# [ no | default ] power poll-interval SECONDS
#--------------------------------------------------------------------------------
class PowerPollIntervalCmd( CliCommand.CliCommandClass ):
   syntax = 'power poll-interval SECONDS'
   noOrDefaultSyntax = 'power poll-interval ...'
   data = {
      'power': 'Configure power supplies',
      'poll-interval': 'Configure Pmbus/Psmi and fixed power supply poll interval',
      'SECONDS': IntegerMatcher( 0, 100,
         helpdesc='Number of seconds between two consecutive polls' ),
   }
   handler = PowerCli.pollInterval
   noOrDefaultHandler = handler

BasicCliModes.GlobalConfigMode.addCommandClass( PowerPollIntervalCmd )

#--------------------------------------------------------------------------------
# [ no | default ] environment power controller poll-interval
#--------------------------------------------------------------------------------
class PowerControllerPollIntervalCmd( CliCommand.CliCommandClass ):
   syntax = ( "environment power controller poll-interval "
              "INTERVAL ( seconds | milliseconds )" )
   noOrDefaultSyntax = "environment power controller poll-interval ..."
   data = {
      'environment' : matcherEnvironment,
      'power' : 'Configure the system behavior for power',
      'controller' : 'Configure the system behavior for power controllers',
      'poll-interval' : matcherPollInterval,
      'INTERVAL' : matcherInterval,
      'seconds' : matcherSeconds,
      'milliseconds' : matcherMilliseconds,
   }
   hidden = True

   handler = PowerCli.setPowerControllerPollInterval
   noOrDefaultHandler = PowerCli.setPowerControllerPollInterval

BasicCliModes.GlobalConfigMode.addCommandClass( PowerControllerPollIntervalCmd )
