#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliPlugin.TrafficPolicyCliLib import ReservedClassMapNames
from CliPlugin.SamplePolicyCliLib import ( SamplePolicyContext,
                                           SamplePolicyMatchRuleContext )
from CliMode.PostcardTelemetry import ( PostcardSamplePolicyConfigMode,
                                        PostcardSamplePolicyMatchRuleIpv4ConfigMode,
                                        PostcardSamplePolicyActionRuleConfigMode )

class PostcardSamplePolicyMatchRuleContext( SamplePolicyMatchRuleContext ):
   def childMode( self, matchRuleName, matchOption ):
      return PostcardSamplePolicyMatchRuleIpv4ConfigMode

   def actionMode( self ):
      return PostcardSamplePolicyActionRuleConfigMode

class PostcardSamplePolicyContext( SamplePolicyContext ):
   def childMode( self ):
      return PostcardSamplePolicyConfigMode

   def reservedClassMapNames( self ):
      return [ ReservedClassMapNames.classV4Default ]
