#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.PmbusCli as PmbusCli

matcherHighLow = CliMatcher.EnumMatcher( {
      'high': 'Power supply high threshold',
      'low': 'Power supply low threshold',
} )
matcherThreshold = CliMatcher.FloatMatcher( 0, float( 'inf' ),
      helpdesc='Threshold for voltage',
      precisionString='%.25g' )
matcherCount = CliMatcher.IntegerMatcher( 0, 100,
      helpdesc='Max number of fault readings' )
matcherPowerSupply = CliMatcher.PatternMatcher( pattern='^PowerSupply[0-9]+$',
      helpdesc='Name of power supply',
      helpname='POWER SUPPLY' )

class PowerSupplyVoltageWarningCmd( CliCommand.CliCommandClass ):
   syntax = ( 'power [ POWER_SUPPLY ] input voltage warning HIGH_LOW THRESHOLD '
              '[ readings COUNT ]' )
   noOrDefaultSyntax = 'power [ POWER_SUPPLY ] input voltage warning HIGH_LOW ...'
   data = {
      'power': 'Configure power supplies',
      'POWER_SUPPLY': matcherPowerSupply,
      'input': 'Power supply input',
      'voltage': 'Power supply voltage',
      'warning': 'Power supply warning',
      'HIGH_LOW': matcherHighLow,
      'THRESHOLD': matcherThreshold,
      'readings': 'Fault readings',
      'COUNT': matcherCount,
   }
   handler = PmbusCli.powerSupplyVoltageWarning
   noOrDefaultHandler = PmbusCli.noPowerSupplyVoltageWarning

BasicCliModes.GlobalConfigMode.addCommandClass( PowerSupplyVoltageWarningCmd )
