#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.PlutoPlatformModuleCli as PlutoPlatformModuleCli
from CliToken.Platform import platformMatcherForExec

slotnameMatcher = CliMatcher.PatternMatcher( pattern='^([a-zA-Z]+)[0-9/]+$',
                                              helpdesc='Name of module slot',
                                              helpname='SLOT' )

moduleMatcher = CliMatcher.KeywordMatcher( 'module',
                                           helpdesc='Platform module' )

#--------------------------------------------------------------------------------
# platform module SLOTNAME power-cycle
#--------------------------------------------------------------------------------
class PlatformModuleSlotnamePowerCycleCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME power-cycle'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'power-cycle' : 'Power cycle module',
   }
   hidden = True

   handler = PlutoPlatformModuleCli.doPowercycleModule

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnamePowerCycleCmd )

#--------------------------------------------------------------------------------
# platform module SLOTNAME remove...
#--------------------------------------------------------------------------------
class PlatformModuleSlotnameRemoveCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME remove'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'remove' : 'Power cycle module and immediately place in to diags',
   }
   hidden = True

   handler = PlutoPlatformModuleCli.doRemoveModule

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnameRemoveCmd )

#--------------------------------------------------------------------------------
# platform module SLOTNAME diags
#--------------------------------------------------------------------------------
class PlatformModuleSlotnameDiagsCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME diags'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'diags' : 'Place module in to diags immediately',
   }
   hidden = True

   handler = PlutoPlatformModuleCli.doDiagModule

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnameDiagsCmd )

#--------------------------------------------------------------------------------
# platform module SLOTNAME insert
#--------------------------------------------------------------------------------
class PlatformModuleSlotnameInsertCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME insert'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'insert' : 'Insert module from diags',
   }
   hidden = True

   handler = PlutoPlatformModuleCli.doInsertModule

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnameInsertCmd )

#--------------------------------------------------------------------------------
# platform module SLOTNAME ( on | off | immediate-off )
#--------------------------------------------------------------------------------
class PlatformModuleSlotnameOffCmd( CliCommand.CliCommandClass ):
   syntax = 'platform module SLOTNAME VALUE'
   data = {
      'platform' : platformMatcherForExec,
      'module' : moduleMatcher,
      'SLOTNAME' : slotnameMatcher,
      'VALUE' : CliMatcher.EnumMatcher( {
         'off' : 'Soft power off the power supply',
         'immediate-off' : 'Immediate power off the power supply',
         'on' : 'Power on the power supply',
       } ),
   }
   hidden = True

   handler = PlutoPlatformModuleCli.doPowerToggleModule

BasicCliModes.EnableMode.addCommandClass( PlatformModuleSlotnameOffCmd )

