#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.PimsmCliClear as PimsmCliClear
from CliPlugin.Ip6AddrMatcher import Ip6AddrMatcher
from CliPlugin.IpAddrMatcher import IpAddrMatcher
from CliToken.Clear import clearKwNode
from CliToken.Ip import ipMatcherForClear
from CliToken.Ipv4 import ipv4MatcherForClear
from CliToken.Ipv6 import ipv6MatcherForClear
from CliToken.Pim import sparseModeMatcher, mrouteMatcher, routeMatcher
from McastCommonCliLib import mcastGenRoutingSupportedGuard

matcherAll = CliMatcher.KeywordMatcher( '*',
      helpdesc='All routes' )
matcherVrf = CliMatcher.KeywordMatcher( 'vrf',
      helpdesc='VRF name' )
matcherVrfValue = CliMatcher.DynamicNameMatcher( PimsmCliClear.getVrfNames,
      'VRF name' )
nodePim = CliCommand.guardedKeyword( 'pim',
      helpdesc='PIM routing information',
      guard=mcastGenRoutingSupportedGuard )

#--------------------------------------------------------------------------------
# clear ip mroute [ vrf VRF ] sparse-mode ( * | { ADDRS } )
# clear pim ipv4 [ vrf VRF ] sparse-mode route ( * | { ADDRS } )
#--------------------------------------------------------------------------------
class ClearPim4SparseModeRouteCmd( CliCommand.CliCommandClass ):
   syntax = '''clear
               ( ( ip mroute [ vrf VRF ] sparse-mode )
               | ( pim ipv4 [ vrf VRF ] sparse-mode route ) )
               ( * | { ADDRS } )'''
   data = {
      'clear': clearKwNode,
      'ip': ipMatcherForClear,
      'mroute': mrouteMatcher,
      'vrf': matcherVrf,
      'VRF': matcherVrfValue,
      'sparse-mode': sparseModeMatcher,
      'pim': nodePim,
      'ipv4': ipv4MatcherForClear,
      'route': routeMatcher,
      '*': matcherAll,
      'ADDRS': CliCommand.Node(
                  matcher=IpAddrMatcher( helpdesc='Source or group address' ),
                  maxMatches=2 ),
   }

   handler = PimsmCliClear.doClearPimRoute

BasicCliModes.EnableMode.addCommandClass( ClearPim4SparseModeRouteCmd )

#--------------------------------------------------------------------------------
# clear pim ipv6 [ vrf VRF ] sparse-mode route ( * | { ADDRS } )
#--------------------------------------------------------------------------------
class ClearPim6SparseModeRouteCmd( CliCommand.CliCommandClass ):
   syntax = 'clear pim ipv6 [ vrf VRF ] sparse-mode route ( * | { ADDRS } )'
   data = {
      'clear': clearKwNode,
      'pim': nodePim,
      'ipv6': ipv6MatcherForClear,
      'vrf': matcherVrf,
      'VRF': matcherVrfValue,
      'sparse-mode': sparseModeMatcher,
      'route': routeMatcher,
      '*': matcherAll,
      'ADDRS': CliCommand.Node(
                  matcher=Ip6AddrMatcher( helpdesc='Source or group address' ),
                  maxMatches=2 ),
   }

   handler = PimsmCliClear.doClearPimRoute

BasicCliModes.EnableMode.addCommandClass( ClearPim6SparseModeRouteCmd )
