# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import TechSupportCli
from McastCommonCli import mcastv6RoutingSupportedGuard
from CliPlugin.PimShowCli import ipPimSupportedGuard

def _showTechCmds():
   cmds = []
   if ipPimSupportedGuard( mode=None, token=None ) is None:
      cmds += [ 'show pim ipv4 vrf all neighbor',
                'show pim ipv4 interface',
                'show ip pim rp',
                'show pim ipv4 sparse-mode join',
                'show ip pim config-sanity',
                'show pim ipv4 protocol counters'
                ]
   if mcastv6RoutingSupportedGuard() is None:
      cmds += [
            'show pim ipv6 vrf all neighbor',
            'show pim ipv6 protocol counters',
            ]
   return cmds

def _showTechSummaryCmds():
   cmds = []
   if ipPimSupportedGuard( mode=None, token=None ) is None:
      cmds += [ 'show pim ipv4 vrf all neighbor' ]
   if mcastv6RoutingSupportedGuard() is None:
      cmds += [ 'show pim ipv6 vrf all neighbor' ]
   return cmds

TechSupportCli.registerShowTechSupportCmdCallback(
    '2010-06-11 02:00:00', _showTechCmds, summaryCmdCallback=_showTechSummaryCmds )
