#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
import CliToken
import CliMatcher
import CliPlugin.PimBsrCliLib as PimBsrCliLib
import CliPlugin.PimBsrConfigCli as PimBsrConfigCli

#--------------------------------------------------------------------------------
# [ no | default ] holdtime HOLDTIME
#--------------------------------------------------------------------------------
class HoldtimeCmd( CliCommand.CliCommandClass ):
   syntax = 'holdtime HOLDTIME'
   noOrDefaultSyntax = 'holdtime ...'
   data = {
      'holdtime': 'Time after which the elected bootstrap router is declared dead',
      'HOLDTIME': CliMatcher.IntegerMatcher( 12, 1073741823, helpdesc=
                                 'Bootstrap outer holdtime in number of seconds' ),
   }
   handler = PimBsrConfigCli.setPimBsrHoldtime
   noOrDefaultHandler = PimBsrConfigCli.noPimBsrHoldtime

PimBsrCliLib.RouterPimBsrAfCommonSharedModelet.addCommandClass( HoldtimeCmd )

#--------------------------------------------------------------------------------
# Legacy:
# (config-router-pim-bsr-*)# [ no | default ] ip pim bsr-holdtime HOLDTIME
#--------------------------------------------------------------------------------
class IpPimBsrHoldtimeLegacyCmd( CliCommand.CliCommandClass ):
   syntax = 'ip pim bsr-holdtime HOLDTIME'
   noOrDefaultSyntax = 'bsr-holdtime ...'
   data = {
      'ip' : CliToken.Ip.ipMatcherForConfig,
      'pim' : CliToken.Pim.pimNode,
      'bsr-holdtime' :
            'Time after which the elected bootstrap router is declared dead',
      'HOLDTIME': CliMatcher.IntegerMatcher( 12, 1073741823, helpdesc=
                                 'Bootstrap outer holdtime in number of seconds' ),
   }
   handler = PimBsrConfigCli.setPimBsrHoldtime
   noOrDefaultHandler = PimBsrConfigCli.noPimBsrHoldtime

PimBsrCliLib.RouterPimBsrSharedModelet.addCommandClass( IpPimBsrHoldtimeLegacyCmd )
BasicCli.GlobalConfigMode.addCommandClass( IpPimBsrHoldtimeLegacyCmd )

#--------------------------------------------------------------------------------
# switch(config-pim-bsr-*) [ no | default ] ipv4
#
# NOTE: The no/default command does NOT have trailing garbage (...).
#       This avoids the possibility of an unwanted match of 'no ip ...'.
#--------------------------------------------------------------------------------
class Ipv4Cmd( CliCommand.CliCommandClass ):
   syntax = 'ipv4'
   noOrDefaultSyntax = 'ipv4'
   data = {
      'ipv4': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'ipv4', helpdesc=
                               'Configure PIM BSR for address family IPV4' ),
                               guard=PimBsrConfigCli.pimBsrModeIpv4SupportedGuard ),
   }
   handler = PimBsrConfigCli.gotoRouterPimBsrIpv4Mode
   noOrDefaultHandler = PimBsrConfigCli.deleteRouterPimBsrIpv4Mode

PimBsrCliLib.RouterPimBsrSharedModelet.addCommandClass( Ipv4Cmd )

#--------------------------------------------------------------------------------
# switch(config-pim-bsr-*) [ no | default ] ipv6
#
# NOTE: The no/default command does NOT have trailing garbage (...).
#       This avoids the possibility of an unwanted match of 'no ip ...'.
#--------------------------------------------------------------------------------
class Ipv6Cmd( CliCommand.CliCommandClass ):
   syntax = 'ipv6'
   noOrDefaultSyntax = 'ipv6'
   data = {
      'ipv6': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'ipv6', helpdesc=
                               'Configure PIM BSR for address family IPV6' ),
                               guard=PimBsrConfigCli.pimBsrModeIpv6SupportedGuard ),
   }
   handler = PimBsrConfigCli.gotoRouterPimBsrIpv6Mode
   noOrDefaultHandler = PimBsrConfigCli.deleteRouterPimBsrIpv6Mode

PimBsrCliLib.RouterPimBsrSharedModelet.addCommandClass( Ipv6Cmd )

class SztimeoutCmd( CliCommand.CliCommandClass ):
   syntax = 'sztimeout SZTIMEOUT'
   noOrDefaultSyntax = 'sztimeout ...'
   data = {
      'sztimeout': 'Time after which the scope-zone is declared timeout',
      'SZTIMEOUT': CliMatcher.IntegerMatcher( 120, 2**32-1,
                             helpdesc='Scoped zone timeout in number of seconds' ),
   }
   handler = PimBsrConfigCli.setPimBsrSzTimeout
   noOrDefaultHandler = PimBsrConfigCli.noPimBsrSzTimeout

PimBsrCliLib.RouterPimBsrAfCommonSharedModelet.addCommandClass( SztimeoutCmd )

class IpPimBsrSztimeoutLegacyCmd( CliCommand.CliCommandClass ):
   syntax = 'ip pim bsr-sztimeout SZTIMEOUT'
   noOrDefaultSyntax = 'ip pim bsr-sztimeout ...'
   data = {
      'ip' : CliToken.Ip.ipMatcherForConfig,
      'pim' : CliToken.Pim.pimNode,
      'bsr-sztimeout': 'Time after which the scope-zone is declared timeout',
      'SZTIMEOUT': CliMatcher.IntegerMatcher( 120, 2**32-1,
                             helpdesc='Scoped zone timeout in number of seconds' ),
   }
   handler = PimBsrConfigCli.setPimBsrSzTimeout
   noOrDefaultHandler = PimBsrConfigCli.noPimBsrSzTimeout

PimBsrCliLib.RouterPimBsrSharedModelet.addCommandClass( IpPimBsrSztimeoutLegacyCmd )
BasicCli.GlobalConfigMode.addCommandClass( IpPimBsrSztimeoutLegacyCmd )
