#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
import CliMatcher
import CliPlugin.PimBsrConfigCli as PimBsrConfigCli
from CliToken.Router import routerMatcherForConfig
from CliToken.Pim import pimNode

bsrMatcher = CliMatcher.KeywordMatcher( 'bsr', helpdesc='PIM-BSR' )

#--------------------------------------------------------------------------------
# [ no | default ] router pim bsr
#--------------------------------------------------------------------------------
class RouterPimBsrCmd( CliCommand.CliCommandClass ):
   syntax = 'router pim bsr'
   noOrDefaultSyntax = 'router pim bsr'
   data = {
      'router' : routerMatcherForConfig,
      'pim' : pimNode,
      'bsr' : bsrMatcher,
   }
   handler = PimBsrConfigCli.gotoRouterPimBsrBaseMode
   noOrDefaultHandler = PimBsrConfigCli.deleteRouterPimBsrBaseMode

BasicCli.GlobalConfigMode.addCommandClass( RouterPimBsrCmd )
