#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliParser
from CliMode.PimBsr import RoutingPimBsrMode, RoutingPimBsrVrfMode, \
      RoutingPimBsrAfMode
import BasicCli
from IpLibConsts import DEFAULT_VRF as vrfDefault
from IpLibConsts import VRFNAMES_RESERVED
from IraCommonCli import AddressFamily

class RouterPimBsrMode( RoutingPimBsrMode, BasicCli.ConfigModeBase ):
   name = 'PIM Bootstrap router configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      self.vrfName = vrfDefault
      RoutingPimBsrMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterPimBsrVrfMode( RoutingPimBsrVrfMode, BasicCli.ConfigModeBase ):
   name = 'PIM Bootstrap Router VRF Configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, vrfName ):
      assert vrfName not in VRFNAMES_RESERVED
      self.vrfName = vrfName
      RoutingPimBsrVrfMode.__init__( self, vrfName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterPimBsrIpv4Mode( RoutingPimBsrAfMode, BasicCli.ConfigModeBase ):
   name = 'IPv4 Pim BSR Mode configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, vrfName=vrfDefault ):
      RoutingPimBsrAfMode.__init__( self, vrfName, AddressFamily.ipv4 )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterPimBsrIpv6Mode( RoutingPimBsrAfMode, BasicCli.ConfigModeBase ):
   name = 'IPv6 Pim BSR Mode configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, vrfName=vrfDefault ):
      RoutingPimBsrAfMode.__init__( self, vrfName, AddressFamily.ipv6 )
      BasicCli.ConfigModeBase.__init__( self, parent, session )


class RouterPimBsrSharedModelet( CliParser.Modelet ):
   modeletParseTree = CliParser.ModeletParseTree()

   def __init__( self, mode ):
      CliParser.Modelet.__init__( self )
      self.mode_ = mode
      self.vrfName = self.mode_.vrfName

RouterPimBsrMode.addModelet( RouterPimBsrSharedModelet )
RouterPimBsrVrfMode.addModelet( RouterPimBsrSharedModelet )

class RouterPimBsrAfSharedModelet( CliParser.Modelet ):
   '''Modelet that has commands available only under ipv* submodes
      Add commands that have ipAddresses or ACLs as arguments here'''
   modeletParseTree = CliParser.ModeletParseTree()

   def __init__( self, mode ):
      CliParser.Modelet.__init__( self )
      self.mode_ = mode
      self.vrfName = self.mode_.vrfName
      self.af = self.mode_.af

RouterPimBsrIpv4Mode.addModelet( RouterPimBsrAfSharedModelet )
RouterPimBsrIpv6Mode.addModelet( RouterPimBsrAfSharedModelet )

class RouterPimBsrAfCommonSharedModelet( CliParser.Modelet ):
   '''Modelet that has commands that is common for ipv* sub modes and
   router pim bsr submode
   Add commands that dont have arguments that are ipAddresses or ACL'''
   modeletParseTree = CliParser.ModeletParseTree()

   def __init__( self, mode ):
      CliParser.Modelet.__init__( self )
      self.mode_ = mode
      self.vrfName = self.mode_.vrfName
      self.af = self.mode_.af

RouterPimBsrIpv4Mode.addModelet( RouterPimBsrAfCommonSharedModelet )
RouterPimBsrIpv6Mode.addModelet( RouterPimBsrAfCommonSharedModelet )


# APIs and classes used in PimBsrConfigCli
class PimBsrCliConfig:
   def __init__( self, pimBsrConfigColl ):
      self.pimBsrConfigColl = pimBsrConfigColl

   def getPimBsrIntfConfig( self, intf, printError=True ):
      intfConfig = self.pimBsrConfigColl.intfConfig
      if intf.name not in intfConfig:
         intfConfig.newMember( intf.name )
      return intfConfig[ intf.name ]

   def maybeDelPimBsrIntfConfig( self, pic ):
      config = self.pimBsrConfigColl
      if not len( config.intfConfig[ pic.name ].bsrBorderGrp ) and \
             not len( config.intfConfig[ pic.name ].bsrBorderAcl ):
         del config.intfConfig[ pic.name ]


def getPimBsrVrfConfig( pimBsrConfig, vrfName ):
   return pimBsrConfig.vrfConfig.get( vrfName )
