#!/usr/bin/env python
# Copyright (c) 2010, 2011, 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount
import PimCliLib
from IpLibConsts import DEFAULT_VRF

_pimBidirDfClearConfigColl = None

def _pimBidirDfConfigCreation( vrfName ):
   _pimBidirDfClearConfigColl.vrfClearConfig.newMember( vrfName )

def _pimBidirDfConfigDeletion( vrfName ):
   if vrfName in _pimBidirDfClearConfigColl.vrfClearConfig:
      if vrfName != DEFAULT_VRF:
         del _pimBidirDfClearConfigColl.vrfClearConfig[ vrfName ]

def clearPimMessageCounters( vrfName, af='ipv4' ):
   # pylint: disable-msg=E1103
   if vrfName in _pimBidirDfClearConfigColl.vrfClearConfig:
      _pimBidirDfClearConfigColl.vrfClearConfig[ vrfName ].countersCount += 1

def Plugin( entityManager ):
   global _pimBidirDfClearConfigColl
   _pimBidirDfClearConfigColl = LazyMount.mount(
         entityManager, 'routing/pim/bidir/df/clear/config',
         'Routing::Pim::Bidir::Df::ClearConfigColl', 'w' )

   PimCliLib.pimClearMessageCountersHook.addExtension( clearPimMessageCounters )

   PimCliLib.pimBidirVrfConfiguredHook.addExtension( _pimBidirDfConfigCreation )
   PimCliLib.pimBidirVrfDeletedHook.addExtension( _pimBidirDfConfigDeletion )
