# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli 
from CliMode.PimBidir import RoutingPimBidirBaseMode, RoutingPimBidirVrfMode
from CliMode.PimBidir import RoutingPimBidirAfMode
import CliParser
from IpLibConsts import DEFAULT_VRF, VRFNAMES_RESERVED
from IraCommonCli import AddressFamily

def isBidirMode( mode ):
   if hasattr( mode, 'protocol' ):
      return mode.protocol == 'bidir'
   return False

class RouterPimBidirBaseMode( RoutingPimBidirBaseMode, BasicCli.ConfigModeBase ):
   name = 'PIM Bidirectional configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      self.vrfName = DEFAULT_VRF
      self.protocol = 'bidir'
      RoutingPimBidirBaseMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterPimBidirVrfMode( RoutingPimBidirVrfMode, BasicCli.ConfigModeBase ):
   name = 'PIM Bidirectional VRF configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, vrfName ):
      assert vrfName not in VRFNAMES_RESERVED
      self.vrfName = vrfName
      self.protocol = 'bidir'
      RoutingPimBidirVrfMode.__init__( self, vrfName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterPimBidirIpv4Mode( RoutingPimBidirAfMode, BasicCli.ConfigModeBase ):
   name = 'IPv4 Pim Bidir Mode configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, vrfName=DEFAULT_VRF ):
      self.protocol = 'bidir'
      RoutingPimBidirAfMode.__init__( self, vrfName, AddressFamily.ipv4 )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterPimBidirIpv6Mode( RoutingPimBidirAfMode, BasicCli.ConfigModeBase ):
   name = 'IPv6 Pim Bidir Mode configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, vrfName=DEFAULT_VRF ):
      self.protocol = 'bidir'
      RoutingPimBidirAfMode.__init__( self, vrfName, AddressFamily.ipv6 )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterPimBidirSharedModelet( CliParser.Modelet ):
   modeletParseTree = CliParser.ModeletParseTree()

   def __init__( self, mode ):
      CliParser.Modelet.__init__( self )
      self.mode_ = mode
      self.vrfName = self.mode_.vrfName

class RouterPimBidirAfSharedModelet( CliParser.Modelet ):
   '''Modelet that has commands available only under ipv* submodes
      Add commands that have ipAddresses or ACLs as arguments here'''
   modeletParseTree = CliParser.ModeletParseTree()

   def __init__( self, mode ):
      CliParser.Modelet.__init__( self )
      self.mode_ = mode
      self.vrfName = self.mode_.vrfName
      self.af = self.mode_.af

class RouterPimBidirAfCommonSharedModelet( CliParser.Modelet ):
   '''Modelet that has commands that is common for ipv* sub modes and
   router pim bidirectional submode
   Add commands that dont have arguments that are ipAddresses or ACL'''
   modeletParseTree = CliParser.ModeletParseTree()

   def __init__( self, mode ):
      CliParser.Modelet.__init__( self )
      self.mode_ = mode
      self.vrfName = self.mode_.vrfName
      self.af = self.mode_.af

#TODO This
RouterPimBidirBaseMode.addModelet( RouterPimBidirSharedModelet )
RouterPimBidirVrfMode.addModelet( RouterPimBidirSharedModelet )
RouterPimBidirIpv4Mode.addModelet( RouterPimBidirAfSharedModelet )
RouterPimBidirIpv6Mode.addModelet( RouterPimBidirAfSharedModelet )

#RouterPimBidirBaseMode.addModelet( RouterPimBidirAfCommonSharedModelet )
#RouterPimBidirVrfMode.addModelet( RouterPimBidirAfCommonSharedModelet )
RouterPimBidirIpv4Mode.addModelet( RouterPimBidirAfCommonSharedModelet )
RouterPimBidirIpv6Mode.addModelet( RouterPimBidirAfCommonSharedModelet )
