#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.OpenFlowCli as OpenFlowCli

#--------------------------------------------------------------------------------
# [ no | default ] openflow
#--------------------------------------------------------------------------------
class OpenflowCmd( CliCommand.CliCommandClass ):
   syntax = 'openflow'
   noOrDefaultSyntax = syntax
   data = {
      'openflow': CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher( 'openflow',
            helpdesc='OpenFlow configuration' ),
         guard=OpenFlowCli.openFlowSupportedGuard ),
   }
   handler = lambda mode, args: OpenFlowCli.gotoOpenFlowConfigMode( mode )
   noOrDefaultHandler = lambda mode, args: OpenFlowCli.clearOpenFlowConfig( mode )

BasicCliModes.GlobalConfigMode.addCommandClass( OpenflowCmd )
