#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.OpenFlowCli as OpenFlowCli
import CliToken.Clear

nodeOpenflow = CliCommand.Node(
      matcher=CliMatcher.KeywordMatcher( 'openflow',
         helpdesc='Clear OpenFlow status' ),
      guard=OpenFlowCli.openFlowSupportedGuard )

#--------------------------------------------------------------------------------
# clear openflow flow NAME counters session
#--------------------------------------------------------------------------------
class ClearFlowCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear openflow flow NAME counters session'
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'openflow': nodeOpenflow,
      'flow': 'Specify the flow',
      'NAME': CliMatcher.DynamicNameMatcher(
         lambda mode: OpenFlowCli.openFlowHwConfig.flowEntry, 'Flow entry name' ),
      'counters': 'Clear openflow counters',
      'session': 'Clear openflow counters of a flow in current session',
   }
   handler = lambda mode, args: OpenFlowCli.clearFlowCounters( mode, args[ 'NAME' ] )

BasicCliModes.EnableMode.addCommandClass( ClearFlowCountersCmd )

#--------------------------------------------------------------------------------
# clear openflow statistics
#--------------------------------------------------------------------------------
class ClearStatisticsCmd( CliCommand.CliCommandClass ):
   syntax = 'clear openflow statistics'
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'openflow': nodeOpenflow,
      'statistics': 'OpenFlow table statistics',
   }
   handler = lambda mode, args: OpenFlowCli.clearStatistics( mode )

BasicCliModes.EnableMode.addCommandClass( ClearStatisticsCmd )
