#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliPlugin.OpenFlowCli as OpenFlowCli

#--------------------------------------------------------------------------------
# [ no | default ] connection auxiliary udp
#--------------------------------------------------------------------------------
class ConnectionAuxiliaryUdpCmd( CliCommand.CliCommandClass ):
   syntax = 'connection auxiliary udp'
   noOrDefaultSyntax = syntax
   data = {
      'connection': 'Configure connection parameters',
      'auxiliary': 'Configure auxiliary connection',
      'udp': 'Protocol UDP',
   }
   handler = lambda mode, args: OpenFlowCli.setAuxConnection( mode, no=None )
   noOrDefaultHandler = lambda mode, args: OpenFlowCli.setAuxConnection( mode,
                                                                         no=True )

OpenFlowCli.ControllerConfigMode.addCommandClass( ConnectionAuxiliaryUdpCmd )
