#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.NetconfCli as NetconfCli

#--------------------------------------------------------------------------------
# netconf start-client
#--------------------------------------------------------------------------------
class NetconfStartClientCmd( CliCommand.CliCommandClass ):
   syntax = 'netconf start-client'
   data = {
      'netconf': 'Configure NETCONF',
      'start-client': 'Start NETCONF client',
   }
   handler = NetconfCli.doNetconfClient

BasicCliModes.UnprivMode.addCommandClass( NetconfStartClientCmd )
