#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# pylint: disable=ungrouped-imports

import BasicCli
import CliCommand
import CliMatcher
import CliPlugin.ConfigMgmtMode as ConfigMgmtMode
import ShowCommand
import CliPlugin.AclCli as AclCli
import CliPlugin.Gnmi as Gnmi
import CliPlugin.OpenConfigShowMgmt as OpenConfigShowMgmt
import CliPlugin.RestconfCli as RestconfCli
from CliPlugin.AclCliModel import AllAclList
from CliPlugin.OpenConfigShowMgmt import (
      GNMIEndpointStatus,
      ModelsStatus,
      NetconfEndpointStatus,
      RestconfEndpointStatus,
)

matcherAccessList = AclCli.accessListKwMatcherForServiceAcl
matcherManagement = ConfigMgmtMode.managementShowKwMatcher
matcherApiForShow = CliMatcher.KeywordMatcher( 'api',
      helpdesc='Show management APIs' )
matcherDynamic = CliMatcher.KeywordMatcher( 'dynamic',
      helpdesc='Dynamic (non-persistent) access-list' )
matcherSummary = CliMatcher.KeywordMatcher( 'summary',
      helpdesc='Access list summary' )
nodeDetail = CliCommand.guardedKeyword(  'detail',
      helpdesc='Access list detail',
      guard=AclCli.countersPerChipEnabledGuard )

#--------------------------------------------------------------------------------
# show management api gnmi access-list [ ACL ] [ summary ] [ dynamic ] [ detail ]
#--------------------------------------------------------------------------------
class ManagementApiGnmiAccessListCmd( ShowCommand.ShowCliCommandClass ):
   syntax = '''show management api gnmi access-list
               [ ACL ] [ summary ] [ dynamic ] [ detail ]
            '''
   data = {
      'management': matcherManagement,
      'api': matcherApiForShow,
      'gnmi': CliCommand.guardedKeyword( 'gnmi',
                 helpdesc='Show status for GNMI endpoints',
                 guard=AclCli.serviceAclGuard ),
      'access-list': matcherAccessList,
      'summary': matcherSummary,
      'dynamic': matcherDynamic,
      'detail': nodeDetail,
      'ACL': AclCli.ipAclNameMatcher,
   }
   handler = Gnmi.showOpenConfigAcl
   cliModel = AllAclList

BasicCli.addShowCommandClass( ManagementApiGnmiAccessListCmd )

#--------------------------------------------------------------------------------
# show management api gnmi
#--------------------------------------------------------------------------------
class ManagementApiGnmiCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management api gnmi'
   data = { 
      'management': matcherManagement,
      'api': matcherApiForShow,
      'gnmi': 'Show status of GNMI endpoint',
   }
   handler = OpenConfigShowMgmt.showStatusGNMI
   cliModel = GNMIEndpointStatus

BasicCli.addShowCommandClass( ManagementApiGnmiCmd )

#--------------------------------------------------------------------------------
# show management api netconf
#--------------------------------------------------------------------------------
class ManagementApiNetconfCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management api netconf'
   data = {
      'management': matcherManagement,
      'api': matcherApiForShow,
      'netconf': 'Show status of netconf endpoint',
   }
   handler = OpenConfigShowMgmt.showStatusNetconf
   cliModel = NetconfEndpointStatus

BasicCli.addShowCommandClass( ManagementApiNetconfCmd )

#--------------------------------------------------------------------------------
# show management api restconf access-list [ ACL ] [ summary ] [ dynamic ] [ detail ]
#--------------------------------------------------------------------------------
class ManagementApiRestconfAccessListCmd( ShowCommand.ShowCliCommandClass ):
   syntax = '''show management api restconf access-list
               [ ACL ] [ summary ] [ dynamic ] [ detail ]
            '''  
   data = {
      'management': matcherManagement,
      'api': matcherApiForShow,
      'restconf': CliCommand.guardedKeyword( 'restconf',
                     helpdesc='Show status for RESTCONF endpoints',
                     guard=AclCli.serviceAclGuard ),
      'access-list': matcherAccessList,
      'summary': matcherSummary,
      'dynamic': matcherDynamic,
      'detail': nodeDetail,
      'ACL': AclCli.ipAclNameMatcher,
   }
   handler = RestconfCli.showRestconfAcl
   cliModel = AllAclList

BasicCli.addShowCommandClass( ManagementApiRestconfAccessListCmd )

#--------------------------------------------------------------------------------
# show management api restconf
#--------------------------------------------------------------------------------
class ManagementApiRestconfCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management api restconf'
   data = {
      'management': matcherManagement,
      'api': matcherApiForShow,
      'restconf': 'Show status of restconf endpoint',
   }
   handler = OpenConfigShowMgmt.showStatusRestconf
   cliModel = RestconfEndpointStatus

BasicCli.addShowCommandClass( ManagementApiRestconfCmd )

#--------------------------------------------------------------------------------
# show management api models
#--------------------------------------------------------------------------------
class ManagementApiModelsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management api models'
   data = {
      'management': matcherManagement,
      'api': matcherApiForShow,
      'models': 'Show status of models',
   }
   handler = OpenConfigShowMgmt.showStatusModels
   cliModel = ModelsStatus

BasicCli.addShowCommandClass( ManagementApiModelsCmd )

