#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliToken.OpenConfigTokens
import CliPlugin.AclCli as AclCli
import CliPlugin.RestconfCli as RestconfCli
import CliPlugin.VrfCli as VrfCli
from CliPlugin.AclCli import ( ipKwForServiceAclMatcher, 
                               inKwMatcher, 
                              accessGroupKwMatcher )

matcherShutdown = CliMatcher.KeywordMatcher( 'shutdown', 
      helpdesc='Disable protocol' )

#--------------------------------------------------------------------------------
# [ no | default ] vrf VRFNAME 
#--------------------------------------------------------------------------------
class Cmd( CliCommand.CliCommandClass ):
   syntax = 'vrf VRFNAME'
   noOrDefaultSyntax = 'vrf ...'
   data = {
      'vrf': 'Configure VRF',
      'VRFNAME': CliMatcher.DynamicNameMatcher( VrfCli.getVrfNames, 'VRF name' ),
   }
   handler = RestconfCli.setVrfName
   noOrDefaultHandler = handler

RestconfCli.RestconfTransportConfigMode.addCommandClass( Cmd )

#--------------------------------------------------------------------------------
# [ no | default ] ip access-group ACLNAME [ in ]
#--------------------------------------------------------------------------------
class IpAccessGroupAclnameCmd( CliCommand.CliCommandClass ):
   syntax = 'ip access-group ACLNAME [ in ]'
   noOrDefaultSyntax = 'ip access-group ...'
   data = {
      'ip': ipKwForServiceAclMatcher,
      'access-group': accessGroupKwMatcher,
      'ACLNAME': AclCli.standardIpAclNameMatcher,
      'in': inKwMatcher,
   }
   handler = RestconfCli.setRestconfAcl
   noOrDefaultHandler = RestconfCli.noRestconfAcl

RestconfCli.RestconfTransportConfigMode.addCommandClass( IpAccessGroupAclnameCmd )

#--------------------------------------------------------------------------------
# [ no | default ] port PORT
#--------------------------------------------------------------------------------
class PortCmd( CliCommand.CliCommandClass ):
   syntax = 'port PORT'
   noOrDefaultSyntax = 'port ...'
   data = {
      'port': 'The port number to listen on',
      'PORT': CliToken.OpenConfigTokens.matcherPortValue,
   }
   handler = RestconfCli.setPort
   noOrDefaultHandler = handler

RestconfCli.RestconfTransportConfigMode.addCommandClass( PortCmd )

#--------------------------------------------------------------------------------
# [ no | default ] shutdown
#--------------------------------------------------------------------------------
class ShutdownCmd( CliCommand.CliCommandClass ):
   syntax = 'shutdown'
   noOrDefaultSyntax = syntax
   data = {
      'shutdown': matcherShutdown,
   }
   handler = RestconfCli.shutdown
   noHandler = RestconfCli.noShutdown
   defaultHandler = RestconfCli.shutdown

RestconfCli.RestconfTransportConfigMode.addCommandClass( ShutdownCmd )

#--------------------------------------------------------------------------------
# [ no | default ] ssl profile PROFILENAME
#--------------------------------------------------------------------------------
class SslProfileProfilenameCmd( CliCommand.CliCommandClass ):
   syntax = 'ssl profile PROFILENAME'
   noOrDefaultSyntax = 'ssl profile ...'
   data = {
      'ssl': 'Configure SSL related options',
      'profile': 'Configure SSL profile',
      'PROFILENAME': RestconfCli.profileNameMatcher,
   }
   handler = RestconfCli.setSslProfile
   noOrDefaultHandler = RestconfCli.noSslProfile

RestconfCli.RestconfTransportConfigMode.addCommandClass( SslProfileProfilenameCmd )

