# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
from CliMatcher import PatternMatcher
import CliPlugin.ModelsCli as ModelsCli


#--------------------------------------------------------------------------------
# AFT
#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------
# [ no | default ] ipv4-unicast
#--------------------------------------------------------------------------------
class AFTIPv4UnicastCmd( CliCommand.CliCommandClass ):
   syntax = 'ipv4-unicast'
   noOrDefaultSyntax = syntax
   data = {
      'ipv4-unicast': 'Enable ipv4-unicast',
   }
   handler = ModelsCli.aftIPv4Unicast
   noOrDefaultHandler = ModelsCli.noAFTIPv4Unicast

ModelsCli.ProviderAFTConfigMode.addCommandClass( AFTIPv4UnicastCmd )

#--------------------------------------------------------------------------------
# [ no | default ] ipv6-unicast
#--------------------------------------------------------------------------------
class AFTIPv6UnicastCmd( CliCommand.CliCommandClass ):
   syntax = 'ipv6-unicast'
   noOrDefaultSyntax = syntax
   data = {
      'ipv6-unicast': 'Enable ipv6-unicast',
   }
   handler = ModelsCli.aftIPv6Unicast
   noOrDefaultHandler = ModelsCli.noAFTIPv6Unicast

ModelsCli.ProviderAFTConfigMode.addCommandClass( AFTIPv6UnicastCmd )

#--------------------------------------------------------------------------------
# Smash
#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------
# [ no | default ] path SMASHPATH [ disabled ]
#--------------------------------------------------------------------------------
class PathSmashCmd( CliCommand.CliCommandClass ):
   syntax = 'path SMASHPATH [ disabled ]'
   noOrDefaultSyntax = syntax
   data = {
      'path': 'Configure a path',
      'SMASHPATH': PatternMatcher( pattern=r'.+',
                                   helpdesc='Smash Path',
                                   helpname='PATH'),
      'disabled': 'Disabled Smash path for Octa',
   }
   handler = ModelsCli.setSmashPath
   noOrDefaultHandler = ModelsCli.noSmashPath

ModelsCli.ProviderSmashConfigMode.addCommandClass( PathSmashCmd )

#--------------------------------------------------------------------------------
# Sysdb
#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------
# [ no | default ] path SYSDBPATH disabled
#--------------------------------------------------------------------------------
class PathSysdbCmd( CliCommand.CliCommandClass ):
   syntax = 'path SYSDBPATH disabled'
   noOrDefaultSyntax = syntax
   data = {
      'path': 'Configure a path',
      'SYSDBPATH': PatternMatcher( pattern=r'.+',
                                   helpdesc='Sysdb Path',
                                   helpname='PATH'),
      'disabled': 'Disabled Sysdb path for Octa',
   }
   handler = ModelsCli.setSysdbPath
   noOrDefaultHandler = ModelsCli.noSysdbPath

ModelsCli.ProviderSysdbConfigMode.addCommandClass( PathSysdbCmd )
