#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliToken.OpenConfigTokens
from CliMatcher import StringMatcher
import CliPlugin.NetconfCli as NetconfCli

#--------------------------------------------------------------------------------
# [ no | default ] transport ssh TRANSPORT_NAME
#--------------------------------------------------------------------------------
class TransportSshCmd( CliCommand.CliCommandClass ):
   syntax = 'transport ssh TRANSPORT_NAME'
   noOrDefaultSyntax = syntax
   data = {
      'transport': CliToken.OpenConfigTokens.matcherTransport,
      'ssh': 'Configure SSH transport for NETCONF',
      'TRANSPORT_NAME': StringMatcher( helpdesc='Transport name', helpname='WORD' ),
   }
   handler = NetconfCli.gotoNetconfTransportConfigMode
   noOrDefaultHandler = NetconfCli.noNetconfTransportConfigMode

NetconfCli.MgmtNetconfConfigMode.addCommandClass( TransportSshCmd )
