# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliPlugin.ModelsCli as ModelsCli

#--------------------------------------------------------------------------------
# [ no | default ] provider aft
#--------------------------------------------------------------------------------
class ProviderAFTCmd( CliCommand.CliCommandClass ):
   syntax = 'provider aft'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'aft': 'Configure AFT provider',
   }
   handler = ModelsCli.gotoProviderAFTConfigMode
   noOrDefaultHandler = ModelsCli.noProviderAFTConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider smash
#--------------------------------------------------------------------------------
class ProviderSmashCmd( CliCommand.CliCommandClass ):
   syntax = 'provider smash'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'smash': 'Configure Smash provider',
   }
   handler = ModelsCli.gotoProviderSmashConfigMode
   noOrDefaultHandler = ModelsCli.noProviderSmashConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider sysdb
#--------------------------------------------------------------------------------
class ProviderSysdbCmd( CliCommand.CliCommandClass ):
   syntax = 'provider sysdb'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'sysdb': 'Configure Sysdb provider',
   }
   handler = ModelsCli.gotoProviderSysdbConfigMode
   noOrDefaultHandler = ModelsCli.noProviderSysdbConfigMode

ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderAFTCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderSmashCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderSysdbCmd )
