#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
from CliMatcher import StringMatcher
import CliPlugin.Gnmi as Gnmi

#--------------------------------------------------------------------------------
# [ no | default ] transport grpc TRANSPORT_NAME
#--------------------------------------------------------------------------------
class TransportGrpcCmd( CliCommand.CliCommandClass ):
   syntax = 'transport grpc TRANSPORT_NAME'
   noOrDefaultSyntax = syntax
   data = {
      'transport': 'Configure a transport',
      'grpc': 'Configure grpc transport for GNMI',
      'TRANSPORT_NAME': StringMatcher( helpdesc='Transport name', helpname='WORD' ),
   }
   handler = Gnmi.gotoGnmiTransportConfigMode
   noOrDefaultHandler = Gnmi.noGnmiTransportConfigMode

Gnmi.MgmtGnmiConfigMode.addCommandClass( TransportGrpcCmd )

#--------------------------------------------------------------------------------
# [ no | default ] provider eos-native
#--------------------------------------------------------------------------------
class ProviderEosNativeCmd( CliCommand.CliCommandClass ):
   syntax = 'provider eos-native'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure provider for GNMI',
      'eos-native': 'Configure native path support for GNMI',
   }
   handler = Gnmi.setEOSNative
   noOrDefaultHandler = Gnmi.noEOSNative

Gnmi.MgmtGnmiConfigMode.addCommandClass( ProviderEosNativeCmd )
