#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.AclCli as AclCli
import CliPlugin.Gnmi as Gnmi
import CliPlugin.ConfigMgmtMode as ConfigMgmtMode
import CliPlugin.RestconfCli as RestconfCli
from CliPlugin.AclCli import accessListKwMatcherForServiceAcl, countersKwMatcher
from CliToken.Clear import clearKwNode

matcherApi = CliMatcher.KeywordMatcher( 'api', helpdesc='Clear management APIs' )

#--------------------------------------------------------------------------------
# clear management api gnmi counters access-list
#--------------------------------------------------------------------------------
class ClearManagementApiGnmiCountersAccessListCmd( CliCommand.CliCommandClass ):
   syntax = 'clear management api gnmi counters access-list'
   data = {
      'clear': clearKwNode,
      'management':  ConfigMgmtMode.managementClearKwMatcher,
      'api': ConfigMgmtMode.apiKwMatcher,
      'gnmi': CliCommand.guardedKeyword( 'gnmi',  
         helpdesc='Clear GNMI statistics', guard=AclCli.serviceAclGuard ),
      'counters': countersKwMatcher,
      'access-list': accessListKwMatcherForServiceAcl,
   }
   handler = Gnmi.clearOpenConfigAclCounters

BasicCliModes.EnableMode.addCommandClass( 
      ClearManagementApiGnmiCountersAccessListCmd )

#--------------------------------------------------------------------------------
# clear management api restconf counters access-list
#--------------------------------------------------------------------------------
class ClearManagementApiRestconfCountersAccessListCmd( CliCommand.CliCommandClass ):
   syntax = 'clear management api restconf counters access-list'
   data = {
      'clear': clearKwNode,
      'management': ConfigMgmtMode.managementClearKwMatcher,
      'api': ConfigMgmtMode.apiKwMatcher,
      'restconf': CliCommand.guardedKeyword( 'restconf', 
         helpdesc='Clear RESTCONF statistics', guard=AclCli.serviceAclGuard ),
      'counters': countersKwMatcher,
      'access-list': accessListKwMatcherForServiceAcl,
   }
   handler = RestconfCli.clearRestconfAclCounters

BasicCliModes.EnableMode.addCommandClass( 
      ClearManagementApiRestconfCountersAccessListCmd )
