# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount

# pkgdeps: rpmwith %{_libdir}/preinit/Security

sslConfig = None

def updateLevelEnabledFlag( config ):
   enabled = any( endpoint.enabled for endpoint in config.endpoints.values() )
   config.enabled = enabled

def otherEnabledTransportExists( mode, name ):
   for e in mode.config_.endpoints.itervalues():
      if e.enabled and e.name != name:
         mode.addError( "transport '%s' of type '%s' is already enabled; "
                        "can not create another" % ( e.name, e.transport ) )
         return True

   return False

def Plugin( entityManager ):
   global sslConfig

   sslConfig = LazyMount.mount( entityManager,
                                "mgmt/security/ssl/config",
                                "Mgmt::Security::Ssl::Config",
                                "r" )
