#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.TrackingCli as TrackingCli
from CliPlugin.IntfCli import Intf

#--------------------------------------------------------------------------------
# [ no | default ] track OBJNAME interface INTF line-protocol
#--------------------------------------------------------------------------------
class TrackObjnameInterfaceIntfLineProtocolCmd( CliCommand.CliCommandClass ):
   syntax = 'track OBJNAME interface INTF line-protocol'
   noOrDefaultSyntax = 'track OBJNAME ...'
   data = {
      'track' : TrackingCli.matcherTrack,
      'OBJNAME' : TrackingCli.matcherObjName,
      'interface' : 'Name an interface',
      'INTF' : Intf.matcher,
      'line-protocol' : 'Track interface line-protocol',
   }
   handler = TrackingCli.trackInterfaceObject
   noOrDefaultHandler = TrackingCli.noOrDefaultTrackObject

BasicCliModes.GlobalConfigMode.addCommandClass( 
   TrackObjnameInterfaceIntfLineProtocolCmd )
