#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliPlugin.IntfCli as IntfCli
import CliPlugin.Ntp as Ntp

#--------------------------------------------------------------------------------
# [ no | default ] ntp serve
#--------------------------------------------------------------------------------
class NtpServeCmd( CliCommand.CliCommandClass ):
   syntax = 'ntp serve'
   noOrDefaultSyntax = 'ntp serve ...'
   data = {
      'ntp': 'Configure NTP',
      'serve': 'Accept NTP requests on this interface',
   }
   handler = Ntp.doNtpServeIntf
   noHandler = Ntp.doRemoveNtpServeIntf
   defaultHandler = Ntp.doRemoveServerModeConfig

IntfCli.IntfConfigMode.addCommandClass( NtpServeCmd )
