#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.AclCli as AclCli
import CliPlugin.Ntp as Ntp
import CliToken.Clear

#--------------------------------------------------------------------------------
# clear ntp ip access-list counters
#--------------------------------------------------------------------------------
class ClearNtpIpAccessListCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear ntp ( ip | ipv6 ) access-list counters'
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'ntp': 'NTP',
      'ip': AclCli.ipKwForClearServiceAclMatcher,
      'ipv6': AclCli.ipv6KwMatcherForClearServiceAcl,
      'access-list': AclCli.accessListKwMatcherForServiceAcl,
      'counters': AclCli.countersKwMatcher
   }
   handler = Ntp.clearNtpIpAclCounters

BasicCliModes.EnableMode.addCommandClass( ClearNtpIpAccessListCountersCmd )
