#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
import ShowCommand
import CliPlugin.NorCalCardCli as NorCalCardCli
from CliToken.Hardware import (
      hardwareMatcherForShow,
)

#--------------------------------------------------------------------------------
# show hardware fabric ejector-handle
#--------------------------------------------------------------------------------
class HardwareFabricEjectorHandleCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware fabric ejector-handle'
   data = {
      'hardware' : hardwareMatcherForShow,
      'fabric' : 'Fabric card configuration',
      'ejector-handle' : CliCommand.guardedKeyword(
          'ejector-handle',
          helpdesc='Ejector handle configuration',
          guard=NorCalCardCli.ejectorHandleGuard ),
   }

   handler = NorCalCardCli.doShowHardwareEjectorHandle
   privileged = True

BasicCli.addShowCommandClass( HardwareFabricEjectorHandleCmd )
