#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.NorCalCardCli as NorCalCardCli
from CliToken.Hardware import (
      hardwareMatcherForConfig,
)

#--------------------------------------------------------------------------------
# hardware fabric ejector-handle open action [ power-off | log ]
# ( no | default ) hardware fabric ejector-handle open action ...
#--------------------------------------------------------------------------------
class HardwareFabricEjectorHandleOpenActionCmd( CliCommand.CliCommandClass ):
   syntax = 'hardware fabric ejector-handle open action VALUE'
   noOrDefaultSyntax = 'hardware fabric ejector-handle open action ...'
   data = {
      'hardware' : hardwareMatcherForConfig,
      'fabric' : CliMatcher.KeywordMatcher( 'fabric',
                                            helpdesc='Fabric card configuration' ),
      'ejector-handle' : CliCommand.guardedKeyword(
          'ejector-handle',
          helpdesc='Ejector handle configuration',
          guard=NorCalCardCli.ejectorHandleGuard ),
      'open' : CliMatcher.KeywordMatcher(
          'open',
          helpdesc='Configure behavior when ejector handles are open' ),
      'action' : CliMatcher.KeywordMatcher(
          'action',
          helpdesc='Action taken when ejector handles are open' ),
      'VALUE' : CliMatcher.EnumMatcher( {
         'power-off' : 'Power-off fabric cards',
         'log' : 'Keep fabric cards powered and output log warning',
       } ),
   }

   handler = NorCalCardCli.doHardwareEjectorHandle
   noOrDefaultHandler = NorCalCardCli.doHardwareEjectorHandlePowerOff

BasicCliModes.GlobalConfigMode.addCommandClass(
   HardwareFabricEjectorHandleOpenActionCmd )
