#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import ConfigMount
import Cell
import CliParser

#-------------------------------------------------------------------------------
# command to configure fabriccard behavior for when ejector handles are open
#    requires "config" mode
#
# full syntax:
#    hardware fabric ejector-handle open action [ power-off | log ]
#    [ no | default ] hardware fabric ejector-handle open action
#-------------------------------------------------------------------------------
def ejectorHandleGuard( mode, token ):
   if Cell.cellType() == "supervisor":
      return None

   return CliParser.guardNotThisPlatform

def doHardwareEjectorHandlePowerOff( mode, args ):
   if ejectorCliConfigMount is None:
      return
   ejectorCliConfigMount.powerOff = True

def doHardwareEjectorHandle( mode, args ):
   if ejectorCliConfigMount is None:
      return
   ejectorCliConfigMount.powerOff = args[ 'VALUE' ] == 'power-off'

#-------------------------------------------------------------------------------
# command to show ejector-handle config
#    requires "enable" mode
#    displays value of powerOff field
#
# full syntax:
#    show hardware fabric ejector-handle
#-------------------------------------------------------------------------------
def doShowHardwareEjectorHandle( mode, args ):
   if ejectorCliConfigMount is None:
      return
   value = "power-off" if ejectorCliConfigMount.powerOff else "log"
   print "Ejector handle open action is %s\n" % value

ejectorCliConfigMount = None
def Plugin( entityManager ):
   global ejectorCliConfigMount
   if Cell.cellType() == "supervisor":
      ejectorCliConfigMount = ConfigMount.mount(
         entityManager,
         "hardware/modularSystem/config/ejector",
         "Hardware::ModularSystem::EjectorCliConfig", "w" )
