#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.LldpStatusCli import escapedString

from NetworkTopologyModels import TopologyHosts
from NetworkTopologyModels import TopologyNeighbors
from NetworkTopologyModels import Host
from NetworkTopologyModels import Port
from NetworkTopologyModels import PortGroup
from NetworkTopologyModels import LogicalPort
from NetworkTopologyModels import DirectedEdge
from NetworkTopologyModels import findHostname

def showEdgesHelper( edgeKey, edge ):
   e = DirectedEdge()
   portName = escapedString( edgeKey.name )
   hostname = findHostname( edgeKey.host() )
   e.fromPort = Port( name=portName, hostname=hostname,
                      hostid=edgeKey.host().name,
                      portChannel= '' )
   for connectedPort in edge.toPort.keys():
      toPort = Port( name=escapedString( connectedPort.name ),
                     hostid=connectedPort.host().name,
                     hostname=findHostname( connectedPort.host() ) )
      toPort.portChannel = ''
      e.toPort.append( toPort )
   return portName, hostname, e

def showNeighbors( status, host ):
   
   topoNeighbors = TopologyNeighbors()
      
   for edgeKey, edge in status.edge.items():
      if host and findHostname( edgeKey.host() ) != host:
         continue
      portName, hostname, e = showEdgesHelper( edgeKey, edge )
      topoNeighbors.neighbors[ '%s-%s' % ( hostname, portName ) ] = e
   
   return topoNeighbors
   
            
def showHosts( status, name, details ):
   topoHosts = TopologyHosts()
   
   hosts = []
   if name:
      for h in status.host.values():
         if findHostname( h, useName=False ) == name:
            hosts.append( h )
   else:
      hosts = status.host.values()

   for host in hosts:
      h = Host( name=host.name, hostname=findHostname( host, useName=False ) )
      h.details = details
      for port in host.port.values():
         portName = escapedString( port.name )
         h.port[ portName ] = Port( name=portName, 
                                    hostid=host.name,
                                    hostname=findHostname( host ) )
         
         h.port[ portName ].portChannel = ""
         if port.portGroup:
            portGroupName = escapedString( port.portGroup.name )
            h.port[ portName ].portChannel = portGroupName

            h.portChannels[ portGroupName ] = PortGroup( name=portGroupName,
                                                         memberPorts=[] )
            for memberPort in port.portGroup.memberPort.itervalues():
               h.portChannels[ portGroupName ].memberPorts.append( 
                  escapedString( memberPort.name ) )

      for logicalPort in host.logicalPort.itervalues():
         portName = escapedString( logicalPort.name )
         h.logicalPorts[ portName ] = LogicalPort( name=portName )
         if logicalPort.type == 'portGroupType':
            for memberPort in logicalPort.memberPort.itervalues():
               h.logicalPorts[ portName ].memberPorts.append( 
                  escapedString( memberPort.name ) )

      topoHosts.hosts[ host.name ] = h

   return topoHosts
