# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
from CliToken.Clear import clearKwNode
from CliPlugin.MacAddr import macAddrMatcher
import CliPlugin.IntfCli as IntfCli
import LazyMount
from TypeFuture import TacLazyType
import Tac
import UtmpDump

identityCliConfig = None
nbrClassficationStatus = None

ClearRequest = TacLazyType( "Identity::NbrClassification::ClearRequest" )
ClearRequestTargetType = TacLazyType(
      "Identity::NbrClassification::ClearRequest::ClearRequestTargetType" )
EthAddr = TacLazyType( "Arnet::EthAddr" )

#------------------------------------------------------------------------------------
# clear neighbor classification
#------------------------------------------------------------------------------------
class ClearNeighborClassification( CliCommand.CliCommandClass ):
   syntax = '''clear neighbor classification ( all |
                                             ( interface INTERFACE ) |
                                             ( mac address MACADDRESS ) )'''
   data = {
      'clear' : clearKwNode,
      'neighbor' : 'Protocol neighbor details',
      'classification' : 'Clear neighbor classification',

      'all' : 'Clear all neighbor classification',

      'interface' : 'Clear neighbor classification on interface',
      'INTERFACE' : IntfCli.Intf.matcher,
      # TODO (BUG473045): replace IntfCli.Intf.matcher with interface range

      'mac' : 'Clear neighbor classification for given MAC',
      'address' : 'Clear neighbor classification for given MAC',
      'MACADDRESS' : macAddrMatcher,
   }

   @staticmethod
   def handler( mode, args ):
      global identityCliConfig
      global nbrClassficationStatus

      def completedRequestsCleanup():
         for k in nbrClassficationStatus.clearRequestTime:
            del identityCliConfig.clearRequest[ k ]

      completedRequestsCleanup()
      info = UtmpDump.getUserInfo()
      who = info[ 'user' ]
      where = info[ 'tty' ]
      timestamp = Tac.now()
      if 'mac' in args:
         targetType = 'mac'
         target = args[ 'MACADDRESS' ]
         addr = EthAddr()
         addr.stringValue = target
         target = addr.displayString
      elif 'interface' in args:
         targetType = 'interface'
         target = args[ 'INTERFACE' ].name
      else:
         targetType = 'all'
         target = 'all'

      reqId = "%f.%s" % ( timestamp, target )
      identityCliConfig.clearRequest[ reqId ] = ClearRequest( timestamp,
                                                              who,
                                                              where,
                                                              targetType,
                                                              target )

BasicCli.EnableMode.addCommandClass( ClearNeighborClassification )

def Plugin( entityManager ):
   global identityCliConfig
   global nbrClassficationStatus

   identityCliConfig = LazyMount.mount( entityManager,
                                        "identity/nbrClassification/cliConfig",
                                        "Identity::NbrClassification::CliConfig",
                                        "w" )

   nbrClassficationStatus = LazyMount.mount( entityManager,
                                             "identity/nbrClassification/status",
                                             "Identity::NbrClassification::Status",
                                             "r" )
