#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import LazyMount
import BasicCli
import ShowCommand
import CliMatcher
import MulticastTunnelModel
import Toggles.McastVpnLibToggleLib
import CliToken.McastVpn
import CliToken.McastCommon

#
# show multicast ipv4|ipv6 evpn encap [ flood ]
# show multicast ipv4|ipv6 evpn decap received [ flood ]
#

_entityManager = None
_ipTunnelVlanGroupStatuses = {}

_ipTunnelStatusTypes = \
   Tac.Type( "Routing::Multicast::IpTunnelGroupStatusType" ).attributes

addressFamilyMatcher = CliMatcher.EnumMatcher( {
   'ipv4': 'Details related to IPv4',
   'ipv6': 'Details related to IPv6'
} )

floodMatcher = \
   CliMatcher.KeywordMatcher( 'flood', helpdesc='VLAN flooding information' )

receivedMatcher = \
   CliMatcher.KeywordMatcher( 'received', helpdesc='Received decapsulation' )

def showMulticastEvpn( mode, args ):
   af = args[ "AF" ]
   statusType = "irbLocalStatus" if "encap" in args else "irbRemoteStatus"
   vlanGroupStatus = _ipTunnelVlanGroupStatuses[ af ][ statusType ]
   model = MulticastTunnelModel.MulticastTunnelVlans()
   model.initFromTacModel( vlanGroupStatus )

   return model

class ShowMulticastEvpn( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast AF evpn encap'

   data = {
      'AF': CliToken.McastCommon.afMatcherForShow,
      'multicast': CliToken.McastCommon.multicastMatcherForShow,
      'evpn': CliToken.McastVpn.evpnForShow,
      'encap': CliToken.McastVpn.encapForShow,
   }
   cliModel = MulticastTunnelModel.MulticastTunnelVlans

   handler = showMulticastEvpn

if Toggles.McastVpnLibToggleLib.toggleMcastVpnUnderlayMulticastEnabled():
   BasicCli.addShowCommandClass( ShowMulticastEvpn )

class ShowMulticastEvpnDecap( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast AF evpn decap received'

   data = {
      'AF': CliToken.McastCommon.afMatcherForShow,
      'multicast': CliToken.McastCommon.multicastMatcherForShow,
      'evpn': CliToken.McastVpn.evpnForShow,
      'decap': CliToken.McastVpn.decapForShow,
      'received': receivedMatcher,
   }
   cliModel = MulticastTunnelModel.MulticastTunnelVlans

   handler = showMulticastEvpn

if Toggles.McastVpnLibToggleLib.toggleMcastVpnUnderlayMulticastEnabled():
   BasicCli.addShowCommandClass( ShowMulticastEvpnDecap )

def showMulticastEvpnFlood( mode, args ):
   af = args[ "AF" ]
   statusType = "irbLocalStatus" if "encap" in args else "irbRemoteStatus"
   vlanGroupStatus = _ipTunnelVlanGroupStatuses[ af ][ statusType ]
   model = MulticastTunnelModel.MulticastFloodVlans()
   model.initFromTacModel( vlanGroupStatus )

   return model

class ShowMulticastEvpnFlood( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast AF evpn encap flood'

   data = {
      'AF': CliToken.McastCommon.afMatcherForShow,
      'multicast': CliToken.McastCommon.multicastMatcherForShow,
      'evpn': CliToken.McastVpn.evpnForShow,
      'encap': CliToken.McastVpn.encapForShow,
      'flood': floodMatcher,
   }
   cliModel = MulticastTunnelModel.MulticastFloodVlans

   handler = showMulticastEvpnFlood

if Toggles.McastVpnLibToggleLib.toggleBullUnderlayMulticastEnabled():
   BasicCli.addShowCommandClass( ShowMulticastEvpnFlood )

class ShowMulticastEvpnDecapFlood( ShowCommand.ShowCliCommandClass ):
   syntax = 'show multicast AF evpn decap received flood'

   data = {
      'AF': CliToken.McastCommon.afMatcherForShow,
      'multicast': CliToken.McastCommon.multicastMatcherForShow,
      'evpn': CliToken.McastVpn.evpnForShow,
      'decap': CliToken.McastVpn.decapForShow,
      'received': receivedMatcher,
      'flood': floodMatcher,
   }
   cliModel = MulticastTunnelModel.MulticastFloodVlans

   handler = showMulticastEvpnFlood

if Toggles.McastVpnLibToggleLib.toggleBullUnderlayMulticastEnabled():
   BasicCli.addShowCommandClass( ShowMulticastEvpnDecapFlood )

def Plugin( entityManager ):

   global _entityManager
   global _ipTunnelVlanGroupStatuses
   global _ipTunnelStatusTypes

   for af in [ "ipv4", "ipv6" ]:
      _ipTunnelVlanGroupStatuses[ af ] = {}
      tacType = "Routing::Multicast::IpTunnelVlanGroupStatus"
      for statusType in _ipTunnelStatusTypes:
         path = Tac.Type( tacType ).mountPath( af, statusType )
         _ipTunnelVlanGroupStatuses[ af ][ statusType ] = \
            LazyMount.mount( entityManager, path, tacType, 'r' )
