#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
from CliPlugin.McastCommonCli import mcastRoutingSupportedGuard
import CliPlugin.MsdpCli as MsdpCli
from CliToken.Router import routerMatcherForConfig
from IpLibConsts import DEFAULT_VRF

#--------------------------------------------------------------------------------
# [ no | default ] router msdp
#--------------------------------------------------------------------------------
class RouterMsdpCmd( CliCommand.CliCommandClass ):
   syntax = 'router msdp'
   noOrDefaultSyntax = syntax
   data = {
      'router': routerMatcherForConfig,
      'msdp': 
         CliCommand.Node(
            matcher=CliMatcher.KeywordMatcher(
               'msdp', helpdesc='MSDP protocol commands' ),
            guard=mcastRoutingSupportedGuard ),
   }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( MsdpCli.RouterMsdpBaseMode )
      mode.session_.gotoChildMode( childMode )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      # delete config all for all VRFs
      for vrfName in MsdpCli.msdpConfig.vrfConfig:
         if vrfName == DEFAULT_VRF:
            MsdpCli.cleanUpMsdpVrfConfig( vrfName )
            continue
         MsdpCli.deleteRouterMsdpVrfMode( mode, vrfName )

BasicCliModes.GlobalConfigMode.addCommandClass( RouterMsdpCmd )
