# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements the Multicast Routing related commands for Etba.
# Configure commands:
# platform etba multicast-routing [config|kernel]
#
# Show commands:
# show platform etba multicast-routing
#-------------------------------------------------------------------------------

import CliToken.Platform, BasicCli, ConfigMount
from BridgingEtbaCli import etbaNode
from CliMatcher import KeywordMatcher, EnumMatcher
from CliCommand import CliCommandClass
from ShowCommand import ShowCliCommandClass

mrouteEtbaConfig = None

mcastRoutingKwMatcher = KeywordMatcher( 'multicast-routing',
   helpdesc='Etba multicast routing configuration commands' )

class McastForwardingStyle( CliCommandClass ):
   syntax = 'platform etba multicast-routing ROUTING_TYPE'
   data = {
      'platform': CliToken.Platform.platformMatcherForConfig,
      'etba': etbaNode,
      'multicast-routing': mcastRoutingKwMatcher,
      'ROUTING_TYPE': EnumMatcher( {
         'kernel': 'Software forwarding by the UNIX kernel',
         'bess': 'Software forwarding by BESS',
         'mfib': '"Hardware" forwarding based on Routing::Multicast::Fib'
      } )
   }

   @staticmethod
   def handler( mode, args ):
      mrouteEtbaConfig.forwardingStyle = 'forwardingStyle%s' % \
         args[ 'ROUTING_TYPE' ].title()

BasicCli.GlobalConfigMode.addCommandClass( McastForwardingStyle )

class ShowForwardingStyle( ShowCliCommandClass ):
   syntax = 'show platform etba multicast-routing'
   data = {
      'platform': CliToken.Platform.platformMatcherForShow,
      'etba': etbaNode,
      'multicast-routing': mcastRoutingKwMatcher
   }

   @staticmethod
   def handler( mode, args ):
      print 'Etba multicast forwarding style:', mrouteEtbaConfig.forwardingStyle

# command is just for testing
BasicCli.addShowCommandClass( ShowForwardingStyle )

def Plugin( entityManager ):
   global mrouteEtbaConfig
   mrouteEtbaConfig = ConfigMount.mount( entityManager,
                                         'routing/multicast/etba/config',
                                         'Routing::Multicast::Etba::Config', 'w' )

