# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArBgpCli import ArBgpAsyncCliCommand
from CliModel import cliPrinted
from CliPlugin.MplsVpnCliModels import mplsVpnRoutesVrfModel

from BgpVpnCli import VpnCliHelperCommand

from RoutingBgpShowCli import (
        arBgpShowCmdDict,
        BgpVrfRoutingContextDefaultOnly,
)

class MplsVpnCliHelperCommand( VpnCliHelperCommand ):
   def __init__( self, mode, command, **kwargs ):
      super( MplsVpnCliHelperCommand, self ).__init__(
         mode, command, None, **kwargs )

   def run( self, **kwargs ):
      super( MplsVpnCliHelperCommand, self ).run( **kwargs )
      return cliPrinted( mplsVpnRoutesVrfModel )

@BgpVrfRoutingContextDefaultOnly( cliModel=mplsVpnRoutesVrfModel )
def doShowBgpMplsVpn( mode, **kwargs ):
   setKwargs = {}
   VpnCliHelperCommand.flattenArgs( kwargs, setKwargs )

   if setKwargs.get( "prefixValue", False ):
      # Set a disctinct prefix value to not colide with Evpn prefix value
      setKwargs[ "mplsVpnPrefixValue" ] = setKwargs.pop( "prefixValue" )

   if setKwargs.get( "internal", False ):
      prefix = setKwargs.pop( "mplsVpnPrefixValue", None )
      ArBgpAsyncCliCommand( mode, "show bgp <af> internal",
                            prefix=prefix, **setKwargs ).run()
      return cliPrinted( mplsVpnRoutesVrfModel )

   return MplsVpnCliHelperCommand( mode, 'show bgp vpn-ipvx', **setKwargs ).run()

arBgpShowCmdDict[ 'doShowBgpMplsVpn' ] = doShowBgpMplsVpn
