# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from CliModel import (
   Enum,
   GeneratorSubmodel,
   Int,
   List,
   Model,
   Str,
   Submodel,
)
from ClientCommonLib import (
   LspPingDSTypes,
   LspPingTypes
)

dsTypeEnum = Tac.Type( 'LspPing::LspPingDownstreamMappingType' ).attributes
retCodeEnum = Tac.Type( 'LspPing::LspPingReturnCode' ).attributes
addrTypeEnum = Tac.Type( 'LspPing::LspPingAddrType' ).attributes

class LabelStackInfo( Model ):
   addrType = Enum( addrTypeEnum, help='Address type' )
   intfAddr = Str( help='Interface address' )
   intfIndex = Int( help='Interface index' )
   ipAddr = Str( help='IP address' )
   labelStack = List( valueType=str, help='Received label stack' )

class DownstreamInfo( Model ):
   addrType = Enum( addrTypeEnum, help='Address type' )
   dsIntfAddr = Str( help='Downstream interface address' )
   dsIntfIndex = Int( help='Downstream interface index' )
   dsIpAddr = Str( help='Downstream IP address' )
   labelStack = List( valueType=str, help='Downstream label stack' )
   retCode = Enum( retCodeEnum, help='Return code' )
   dsType = Enum( values=dsTypeEnum, help='Downstream information type' )

class HopPktInfo( Model ):
   replyHost = Str( help='Reply address' )
   hopMtu = Int( help='Hop MTU' )
   roundTrip = Int( help='Roundtrip time (ms)' )
   retCode = Enum( retCodeEnum, help='Return code' )
   ttl = Int( help='Time to live' )
   dsInfo = List( valueType=DownstreamInfo, help='Downstream infos' )
   labelStackInfo = Submodel( valueType=LabelStackInfo, help="LabelStack info" )

class MplsVia( Model ):
   nextHopIp = Str( help='NextHop IP' )
   labelStack = List( valueType=int, help='LabelStack' )
   hopPkt = List( valueType=HopPktInfo, help="HopPktInfos" )

class MplsUtilTraceroute( Model ):
   prefix = Str( help='Destination' )
   protocol = Enum( values=LspPingTypes, help='Protocol' )
   dsInfoType = Enum( values=LspPingDSTypes, help='Downstream information type' )
   viaModel = List( valueType=MplsVia, help="Vias" )

# Parent model for Multipath/Non-Multipath for all protocols
# with submodels inside.
class MplsUtilTracerouteModel( Model ):
   traceroute = GeneratorSubmodel( valueType=MplsUtilTraceroute,
                                   help="Traceroute request" )
   def render( self ):
      pass
