#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from CliModel import Model, Dict, Int, Bool
from TableOutput import createTable, Format

MplsLabel = Tac.Type( 'Arnet::MplsLabel' )

def printt( val, indent=0 ):
   print ' ' * 3 * indent + val

class MplsLfibCounterLabelEntry( Model ):
   totalPackets = Int( help="Total number of received packets on label" )
   totalBytes = Int( help="Total number of received bytes on label" )
   unprogrammed = Bool( help="Route is unprogrammed in hardware" )

class MplsLfibCounters( Model ):
   counters = Dict( keyType=int, valueType=MplsLfibCounterLabelEntry,
                    help="A dictionary of ingress MPLS LFIB counters keyed by "
                         "their top label" )
   multiLabelCounters = Dict( valueType=MplsLfibCounterLabelEntry,
                              help="A dictionary of ingress multi-label MPLS LFIB "
                                   "counters keyed by their top labels (ordered "
                                   "top-most to bottom-most)",
                              optional=True )

   def render( self ):
      if not self.counters and not self.multiLabelCounters:
         return

      headers = [ 'Label', 'Packets', 'Bytes' ]
      f1 = Format( justify='left', minWidth=12 )
      f1.padLimitIs( True )
      f2 = Format( justify='right', minWidth=18 )
      f2.padLimitIs( True )
      outputTable = createTable( headers )
      for counterDict in [ self.counters, self.multiLabelCounters ]:
         for counterKey, counter in sorted( counterDict.iteritems() ):
            if counterKey == MplsLabel.null:
               continue
            labelStr = str( counterKey ) + ( " [U]" if counter.unprogrammed else "" )
            outputTable.newRow( labelStr, counter.totalPackets, counter.totalBytes )

      # Now print out labels that are not being counted.
      counter = self.counters.get( MplsLabel.null )
      if counter:
         outputTable.newRow( "Other", counter.totalPackets, counter.totalBytes )

      outputTable.formatColumns( f1, f2, f2 )
      printt( "U - Unprogrammed" )
      printt( outputTable.output() )
