# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# pylint: disable=ungrouped-imports

import BasicCli
import CliCommand
import CliMatcher
import ShowCommand
from CliPlugin.MplsCliModel import MplsInterfaceIngressCounters, MplsInterfaceModel
from Intf.IntfRange import IntfRangeMatcher
import CliPlugin.MplsCli as MplsCli
import CliPlugin.MplsCliCommands as MplsCliCommands

matcherInterface = CliMatcher.KeywordMatcher(
   'interface', helpdesc='Network interface' )
matcherCounters = CliMatcher.KeywordMatcher(
   'counters', helpdesc='MPLS interface ingress counters' )

nodeCounters = CliCommand.Node( matcher=matcherCounters,
                                guard=MplsCliCommands.mplsInterfaceCountersGuard )

#--------------------------------------------------------------------------------
# show mpls interface [INTERFACE]
#--------------------------------------------------------------------------------
class MplsInterfaceCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mpls interface [INTERFACE]'
   data = {
      'mpls' : MplsCli.mplsNodeForShow,
      'interface' : matcherInterface,
      'INTERFACE' : IntfRangeMatcher( explicitIntfTypes=MplsCliCommands.intfTypes ),
   }
   handler = MplsCliCommands.generateInterfaceModel
   cliModel = MplsInterfaceModel

BasicCli.addShowCommandClass( MplsInterfaceCmd )

#--------------------------------------------------------------------------------
# show mpls interface [INTERFACE] counters
#--------------------------------------------------------------------------------
class MplsInterfaceCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mpls interface [INTERFACE] counters'
   data = {
      'mpls' : MplsCli.mplsNodeForShow,
      'interface' : matcherInterface,
      'INTERFACE' : IntfRangeMatcher( explicitIntfTypes=MplsCliCommands.intfTypes ),
      'counters' : nodeCounters,
   }
   handler = MplsCliCommands.showInterfacesMplsCounter
   cliModel = MplsInterfaceIngressCounters

BasicCli.addShowCommandClass( MplsInterfaceCountersCmd )
