#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Bool
from CliModel import Int
from CliModel import List
from CliModel import Model
from CliModel import Str
from IntfModel import Interface

class MonitoredNexthopEntry( Model ):
   ipAddr = Str( help='Nexthop Ip or Ipv6 address' )
   intf = Interface( help='Name of the interface' )

class MonitoredNexthopVrfSummary( Model ):
   vrfname = Str( help='Name of the Vrf' )
   entries = Int( default=0,
                  help="Total number of monitored nexthop entries for the Vrf" )

class MonitoredNexthopCollection( Model ):
   totalEntries = Int( default=0,
                       help="Total number of monitored nexthop entries" )
   entryList = List( valueType=MonitoredNexthopEntry,
                     help="Monitored nexthop entry" )
   _render_summary = Bool( help="Display summary only for show command if True", 
                           default=False )
   vrfList = List( valueType=MonitoredNexthopVrfSummary,
                   help="Monitored nexthop entry count" )
   def render( self ):
      if self._render_summary:
         print "Total: %s" % self.totalEntries
         for i in self.vrfList:
            print '%-15s %-8d' % ( i.vrfname, i.entries )
      else:
         print 'Address                                  Interface '
         for i in self.entryList:
            print '%-39s  %-8s' % ( i.ipAddr, i.intf.stringValue )
