#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.VrfCli as VrfCli
import LazyMount
import Tac
from IpLibConsts import DEFAULT_VRF
from MonitoredNexthopModel import MonitoredNexthopEntry
from MonitoredNexthopModel import MonitoredNexthopCollection
from MonitoredNexthopModel import MonitoredNexthopVrfSummary
#-------------------------------------------------------------------------------
# Aliases for some useful token rules.
#-------------------------------------------------------------------------------
nhStatus = None

vrfStatusDir = None

AddressFamily = Tac.Type( "Arnet::AddressFamily" )
def eligibleMonitoredNextHopEntry( intfId, ipGenAddr ):

   if not intfId or intfId == Tac.Value( "Arnet::IntfId", "" ):
      return False

   if Tac.Type( "Arnet::MgmtIntfId" ).isMgmtIntfId( intfId ):
      return False

   assert ipGenAddr.af != AddressFamily.ipunknown

   if ipGenAddr.isAddrZero:
      return False

   return True

def showMonitoredNexthop( mode, args ):
   vrfName = args.get( 'VRF' )
   assert vrfName != ''
   vrfName = VrfCli.vrfMap.lookupCliModeVrf( mode, vrfName )
   model = MonitoredNexthopCollection( _render_summary=False )
   allNhStatus = None

   if vrfName != DEFAULT_VRF:
      if vrfName in vrfStatusDir.vrfStatus:
         allNhStatus = vrfStatusDir.vrfStatus[ vrfName ].nextHop
      else:
         return model
   else:
      allNhStatus = nhStatus.nextHop

   assert allNhStatus != None

   # show each entries
   model.entryList = []
   for nexthop in sorted ( allNhStatus ):
      if not eligibleMonitoredNextHopEntry( nexthop.intfId, nexthop.ipGenAddr ):
         continue
      entryModel = MonitoredNexthopEntry(
         ipAddr=nexthop.ipGenAddr.stringValue, intf=nexthop.intfId )
      model.entryList.append( entryModel )  # pylint:disable-msg=E1101
   return model

def addToModel( nexthopStatus, vrfName, model ):
   allNhStatus = nexthopStatus.nextHop
   entries = len ( allNhStatus.keys() )
   for nexthop in allNhStatus:
      if not eligibleMonitoredNextHopEntry( nexthop.intfId, nexthop.ipGenAddr ):
         entries -= 1

   model.totalEntries += entries
   vrfModel = MonitoredNexthopVrfSummary( vrfname=vrfName,
                                          entries=entries )
   model.vrfList.append( vrfModel )

def showMonitoredNexthopSummary( mode, args ):
   model = MonitoredNexthopCollection( _render_summary=True )

   model.totalEntries = 0
   model.vrfList = []

   # collection entries from default vrf
   addToModel( nhStatus, "default", model )

   # collection entries from all other vrfs
   for i in vrfStatusDir.vrfStatus:
      addToModel( vrfStatusDir.vrfStatus[ i ], i, model )

   return model

#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global nhStatus
   global vrfStatusDir
   nhStatus = LazyMount.mount( entityManager, "arp/monitorednexthop/status",
                               "Arp::MonitoredNexthop::Status", "r" )
   vrfStatusDir = LazyMount.mount( entityManager, "arp/monitorednexthop/vrf/status",
                                   "Arp::MonitoredNexthop::VrfStatusDir", "r" )
