# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Ethernet
from CliModel import Bool
from FhrpModels import VirtualRouterMacModel 

class MlagPeerRouterMac( VirtualRouterMacModel ):
   configured = Bool( help="True if the routing using Mlag peer MAC address "
                           "is configured." )
   def render( self ):
      peerMacAddr = str( self.macAddress )
      if self.configured and peerMacAddr != '00:00:00:00:00:00':
         print 'IP router is configured with Mlag peer MAC address:',
         print Ethernet.convertMacAddrToDisplay( peerMacAddr )
      else:
         print 'IP router is not configured with Mlag peer MAC address'
