#!/usr/bin/env python
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount, Intf.Log
from .MlagTunnelModel import MlagTunnel

mlagTunnelStatus = None
mlagTunnelConfig = None

#-------------------------------------------------------------------------------
# show mlag tunnel
#-------------------------------------------------------------------------------
def showMlagTunnel( mode, args ):
   model = MlagTunnel( rxPkts=mlagTunnelStatus.rxPkts,
                       txPkts=mlagTunnelStatus.txPkts,
                       decPkts=mlagTunnelStatus.decPkts,
                       encPkts=mlagTunnelStatus.encPkts )
   for typ, encDec in mlagTunnelStatus.encDecPkts.iteritems():
      if typ != 'MLAG Heartbeat':
         model.pktTypeCounters[ typ ] = MlagTunnel.PktTypeCounters(
            decPkts=encDec.decPkts, encPkts=encDec.encPkts )
   return model

import CliPlugin.TechSupportCli
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
   '2013-10-03 15:20:39', lambda: [ 'show mlag tunnel counters' ] )

#-------------------------------------------------------------------------------
# clear mlag tunnel counters
#-------------------------------------------------------------------------------
def clearMlagTunnelCounters( mode, args ):
   Intf.Log.logClearCounters( "mlag" )
   mlagTunnelConfig.clearCounters += 1 # pylint: disable-msg=E1103

#-------------------------------------------------------------------------------
# Mounts
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global mlagTunnelStatus, mlagTunnelConfig
   mlagTunnelStatus = LazyMount.mount( entityManager, "mlag/tunnel/status", 
                                       "Mlag::TunnelStatus", "r" )
   mlagTunnelConfig = LazyMount.mount( entityManager, "mlag/tunnel/config", 
                                       "Mlag::TunnelConfig", "w" )
