#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.MlagConfigCli as MlagConfigCli
from CliPlugin.MlagShowCli import mlagSupportedGuard

matcherConfiguration = CliMatcher.KeywordMatcher( 'configuration', 
      helpdesc='MLAG configuration' )
matcherMlag = CliMatcher.KeywordMatcher( 'mlag', helpdesc='MLAG configuration' )
nodeMlag = CliCommand.Node( matcher=matcherMlag, guard=mlagSupportedGuard )

#--------------------------------------------------------------------------------
# ( no | default ) mlag configuration
#--------------------------------------------------------------------------------
class MlagConfigurationCmd( CliCommand.CliCommandClass ):
   syntax = 'mlag [ configuration ]'
   noOrDefaultSyntax = 'mlag configuration'
   data = {
      'mlag': nodeMlag,
      'configuration': matcherConfiguration,
   }
   handler = MlagConfigCli.gotoMlagMode
   noOrDefaultHandler = MlagConfigCli.noMlagMode

BasicCliModes.GlobalConfigMode.addCommandClass( MlagConfigurationCmd )
