#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.MlagTunnelCli as MlagTunnelCli
from CliPlugin.MlagShowCli import mlagSupportedGuard
from CliToken.Clear import clearKwNode

matcherMlag = CliMatcher.KeywordMatcher( 'mlag', helpdesc='MLAG information' )
nodeMlag = CliCommand.Node( matcher=matcherMlag, guard=mlagSupportedGuard )

#--------------------------------------------------------------------------------
# clear mlag tunnel counters
#--------------------------------------------------------------------------------
class ClearMlagTunnelCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear mlag tunnel counters'
   data = {
      'clear': clearKwNode,
      'mlag': nodeMlag,
      'tunnel': 'MLAG tunnel information',
      'counters': 'MLAG tunnel counters',
   }
   handler = MlagTunnelCli.clearMlagTunnelCounters

BasicCliModes.EnableMode.addCommandClass( ClearMlagTunnelCountersCmd )
