#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.TapAggPmapCli as TapAggPmapCli
from CliToken.Clear import clearKwNode

matcherSession = CliMatcher.KeywordMatcher( 'session',
   helpdesc='Clear TapAgg policy-map counters in current session' )

#--------------------------------------------------------------------------------
# clear policy-map type tapagg counters [ PMAPNAME ] [ session ]
#--------------------------------------------------------------------------------
class ClearPolicyMapTypeTapaggCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear policy-map type tapagg counters [ PMAPNAME ] [ session ]'
   data = {
      'clear': clearKwNode,
      'policy-map': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'policy-map',
         helpdesc='Clear Policy Map' ), guard=TapAggPmapCli.guardPMapTapAgg ),
      'type': 'Specify type',
      'tapagg': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'tapagg',
         helpdesc='TapAgg type' ), guard=TapAggPmapCli.guardPMapTapAgg ),
      'counters': 'Clear TapAgg policy-map counters',
      'session': matcherSession,
      'PMAPNAME': CliMatcher.DynamicNameMatcher( TapAggPmapCli.getPMapNameRuleTapAgg,
         'TapAgg Policy Map Name' ),
   }
   handler = TapAggPmapCli.clearTapAggPMapCounters

BasicCliModes.EnableMode.addCommandClass( ClearPolicyMapTypeTapaggCountersCmd )
