#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import BasicCli
import ShowCommand
import CliPlugin.ManagementActiveIntfCli as ManagementActiveIntfCli
from CliPlugin.ManagementActiveIntfModel import MgmtActiveIntfRedundancyStatus
import CliToken.Redundancy as Redundancy

#--------------------------------------------------------------------------------
# show redundancy backup-link
#--------------------------------------------------------------------------------
class RedundancyBackupLinkCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show redundancy backup-link'
   data = {
      'redundancy': Redundancy.redundancyForShowGuarded,
      'backup-link': 'Management0 backup link details',
   }
   handler = ManagementActiveIntfCli.doShowRedBackupLink
   cliModel = MgmtActiveIntfRedundancyStatus

if Cell.cellType() == 'supervisor':
   BasicCli.addShowCommandClass( RedundancyBackupLinkCmd )
