#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliPlugin.EthIntfCli as EthIntfCli
from CliModel import Model
from CliModel import Bool
from IntfModel import Interface
from CliModel import Float

#-------------------------------------------------------------------------------
# EthIntf specific Eapi Models
#-------------------------------------------------------------------------------
class MgmtActiveIntfRedundancyStatus( Model ):
   name = Interface( help="Name of the interface", optional=True )
   redundancy = Bool( help='Is redundancy enabled', optional=True )
   redundancyIntf = Interface( help="Name of the interface", optional=True )
   lastRedundancyLinkChangeTime = Float( help="Time when last link changed",
                                  optional=True )

   def timeString( self, elapsed, output, units ):
      assert isinstance( elapsed, int )
      if units:
         _ , unit = units[ -1 ]
         assert ( unit == 1 ), "Last unit must have 1 as a unit value"
      if ( elapsed > 0 ) and units:
         localName, localUnits = units[0] 
         value = elapsed % localUnits if len( units ) > 1 else elapsed
         if( value > 0 ):
            output = ( "%d %s"%( value, localName + ( "s" if value > 1 else "" ) )
                        + ( ( ", " + output ) if output else "" ) )
         return( self.timeString( elapsed//localUnits, 
                 output, units[1:] ) )
      else: 
         return( output ) 

   def renderRedundancy( self ):
      if self.name and EthIntfCli.isModular():
         # pylint: disable-msg=no-member
         print "%s" % self.name.stringValue
         if self.redundancy:
            print "  Redundancy: Enabled"
            if self.redundancyIntf:
               print "  Redundancy active interface: %s" % (
                  self.redundancyIntf.stringValue )
            else:
               print "  Redundancy active interface: n/a"
            if self.lastRedundancyLinkChangeTime:
               timeDelta = int( Tac.now() - self.lastRedundancyLinkChangeTime )
               uptimeString = self.timeString( timeDelta, "",
                                             [ ( "second", 60 ), ( "minute", 60 ),
                                               ( "hour", 24 ), ( "day", 365 ),
                                               ( "year", 1 ) ] )
               uptimeString = uptimeString + " ago"
            else:
               uptimeString = "never"
            print "  Last redundancy link change: %s" % uptimeString
         else:
            print "  Redundancy: Disabled"
            print "  Redundancy active interface: n/a" 
            print "  Last redundancy link change: n/a"
         # pylint: enable-msg=no-member

   def render( self ):
      self.renderRedundancy()


