# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import LazyMount
from CliPlugin.MaintenanceModels import showMaintenanceInterfaceHook
from CliPlugin.MaintenanceModels import showMaintenanceSummaryHook
from CliPlugin.MaintenanceModels import MaintenanceInterfaceRateMonStatus
from CliPlugin.MaintenanceModels import MaintenanceRateMonSummary
from MaintenanceCliLib import toUtc
from MaintenanceCliLib import defaultProfile

monIntfStatusDir = None
errDisableCauseStatus = None


def intfShowMaintenanceIntf( mode, intfId, status ):
   monIntfStatus = monIntfStatusDir.monIntfStatus.get( intfId )
   if not monIntfStatus:
      return
   status.rateMonStatus = rateMonStatus_ = MaintenanceInterfaceRateMonStatus()
   rateMonStatus_.state = monIntfStatus.state
   rateMonStatus_.stateTime = toUtc( monIntfStatus.stateTime )
   rateMonStatus_.startTime = toUtc( monIntfStatus.startTime )
   rateMonStatus_.profile = monIntfStatus.profileName
   if rateMonStatus_.profile == defaultProfile:
      rateMonStatus_.profile = 'Default'
   rateMonStatus_.lastSampleTime = toUtc( monIntfStatus.lastSampleTime )
   rateMonStatus_.lastInBpsRate = monIntfStatus.curRates.inBitsRate
   rateMonStatus_.lastOutBpsRate = monIntfStatus.curRates.outBitsRate
   rateMonStatus_.totalSamples = monIntfStatus.totalSamples
   rateMonStatus_.numSamplesAboveThresholdPreMaint = \
         monIntfStatus.numSamplesAboveThresholdPreMaint
   rateMonStatus_.numSamplesBelowThresholdPreMaint = \
         monIntfStatus.numSamplesBelowThresholdPreMaint
   rateMonStatus_.numSamplesAboveThresholdPostMaint = \
         monIntfStatus.numSamplesAboveThresholdPostMaint
   rateMonStatus_.numSamplesBelowThresholdPostMaint = \
         monIntfStatus.numSamplesBelowThresholdPostMaint
   errDisableCauseIntfStatus = errDisableCauseStatus.intfStatus.get( intfId )
   if errDisableCauseIntfStatus:
      rateMonStatus_.maintDownTime = \
            toUtc( errDisableCauseIntfStatus.errdisabledTime )
   return

def intfShowMaintenanceSummary( mode, model ):
   model.rateMonSummary = rms = MaintenanceRateMonSummary()
   rms.numIntfsEnterMaint = len( monIntfStatusDir.monIntfEnterMaint )
   rms.numIntfsUnderMaint = len( monIntfStatusDir.monIntfUnderMaint )
   rms.numIntfsThresholdViolation = len( monIntfStatusDir.monIntfSpikeUnderMaint )
   rms.numIntfsMaintDown = len( errDisableCauseStatus.intfStatus )

def Plugin( entityManager ):
   global monIntfStatusDir, errDisableCauseStatus
   showMaintenanceInterfaceHook.addExtension( intfShowMaintenanceIntf )
   showMaintenanceSummaryHook.addExtension( intfShowMaintenanceSummary )
   monIntfStatusDir = LazyMount.mount( entityManager,
                                       'maintenance/interface/status/ratemon',
                                       'Maintenance::MonIntfStatusDir', 'r' )
   errDisableCauseStatus = LazyMount.mount( entityManager,
                           'interface/errdisable/cause/maintenance-shutdown',
                           'Errdisable::CauseStatus', 'r' )
