#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli, CliParser
from CliMode.MaintenanceUnitMode import MaintenanceUnitMode
from CliMode.MaintenanceMode import MaintenanceMode
from CliMode.MaintenanceUnitProfileMode import MaintenanceUnitProfileMode
from CliMode.MaintenanceBuiltinUnitMode import MaintenanceBuiltinUnitMode

class MaintenanceUnitConfigMode( MaintenanceUnitMode, BasicCli.ConfigModeBase ):
   name = "Maintenance unit configuration"
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, maintenanceUnit ):
      self.maintenanceUnit_ = maintenanceUnit
      self.session_ = session
      MaintenanceUnitMode.__init__( self, self.maintenanceUnit_.name() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class MaintenanceConfigMode( MaintenanceMode, BasicCli.ConfigModeBase ):
   name = "MaintenanceMode configuration"
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      self.session_ = session
      MaintenanceMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class MaintenanceUnitProfileConfigMode( MaintenanceUnitProfileMode,
                                        BasicCli.ConfigModeBase ):
   name = "Maintenance Unit profile configuration"
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, unitProfile ):
      self.unitProfile_ = unitProfile
      self.session_ = session
      MaintenanceUnitProfileMode.__init__( self, self.unitProfile_.name() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class MaintenanceBuiltinUnitConfigMode( MaintenanceBuiltinUnitMode,
                                        BasicCli.ConfigModeBase ):
   name = "Maintenance builtin Unit Configuration"
   modeParseTree = CliParser.ModeParseTree()
   
   def __init__( self, parent, session, builtinUnit, unitObject=None ):
      self.builtinUnit_ = builtinUnit
      self.session_ = session
      self.unitObject_ = unitObject
      MaintenanceBuiltinUnitMode.__init__( self, self.builtinUnit_ )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
