# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

globalMaintenanceGroupConfigDir = None
import ConfigMount
import Tac

#
# MaintenanceGroup class: Holds cli state for each configured maintenance group
#    such as profiles associated with a group
#
class MaintenanceGroup():
   def __init__( self, groupKey ):
      self.groupKey = groupKey

   def addProfile( self, profileKey ):
      maintenanceGroup = \
          globalMaintenanceGroupConfigDir.newMaintenanceGroup( self.groupKey )
      maintenanceGroup.profile[ profileKey ] = True

   def remProfile( self, profileType, profileName ):
      maintenanceGroup = \
          globalMaintenanceGroupConfigDir.maintenanceGroup.get( 
            self.groupKey, None ) 
      if maintenanceGroup:
         if profileName is None:
            for profile in maintenanceGroup.profile.keys():
               if profile.type == profileType:
                  profileName = profile.name
         profileKey = Tac.Value( "Maintenance::Profile::ProfileKey", 
                                 type = profileType, name = profileName )
         del maintenanceGroup.profile[ profileKey ]

         if not maintenanceGroup.profile.items():
            del globalMaintenanceGroupConfigDir.maintenanceGroup[ self.groupKey ]

   def remGroup( self ):
      del globalMaintenanceGroupConfigDir.maintenanceGroup[ self.groupKey ]

def Plugin( entityManager ):
   global globalMaintenanceGroupConfigDir
   globalMaintenanceGroupConfigDir = ConfigMount.mount( entityManager,
      'maintenance/group/config', 'Maintenance::MaintenanceGroup::ConfigDir', 'w' )

